
let rain = [];
let rainingNow = false;
let song;
let rainsound;
let button;
let jumpButton;
let img;
let img2;
let addCue;
let slider;

function preload() {
  song = loadSound("raindroptrail.mp3", loaded);
  rainsound = loadSound("raining.wav", loaded2);
}

function setup() {
  createCanvas(600, 600);
  img = loadImage('alone.jpg');
  img2 = loadImage('rain2.jpg');
  song.addCue(5, changeBackground);
  button = createButton("play");
  button.mousePressed(togglePlaying);
  jumpButton = createButton("jump");
  jumpButton.mousePressed(jumpSong);
  slider = createSlider(0, 1, 0.5, 0.01);                
  for (i = 0; i < 300; i++) {
    rain[i] = new Rain(random(50, 550), random(0, -3000));
  }
}

function loaded() {
  console.log("loaded song")
}


function loaded2() {

}


function changeBackground() {
  backgound(255);
}

function jumpSong() {
  let len = song.duration();
  song.jump(random(len));

}


function draw() {
  background(img);
  song.setVolume(slider.value());

  if (rainingNow == true) {
    background(img2);
    for (i = 0; i < rain.length; i++) {
      rain[i].dropRain();
      rain[i].splash();
    }
  } else {
  

  }
  if (song.currentTime() > 30) {
    background(img);
    for (i = 0; i < rain.length; i++) {
      rain[i].dropRain();
      rain[i].splash();
    }

  }
}

function togglePlaying() {
  if (!song.isPlaying()) {
    song.play();
    rainsound.play();
    rainsound.setVolume(0.1);
    song.setVolume(0.3);
    button.html("pause");
    rainingNow = true;

  }
  else {
    song.pause();
    rainsound.pause();
    button.html("play");
    background(img);
    rainingNow = false;
  }
}


function Rain(x, y) {
  this.x = x;
  this.y = y;
  this.length = 12;
  this.r = 0;
  this.opacity = 200;


  this.dropRain = function () {
    noStroke();
    fill(255);

    ellipse(this.x, this.y, 3, this.length);
    this.y = this.y + 6
    if (this.y > 540) {
      this.length = this.length - 5;

    }
    if (this.length < 0) {
      this.length = 0;
    }
  }

  this.splash = function () {
    strokeWeight(2);

    stroke(245, this.opacity);
    noFill();
    if (this.y > 540) {
      ellipse(this.x, 550, this.r * 2, this.r / 2);
      this.r++;
      this.opacity = this.opacity - 10;

      //keep the rain dropping
      if (this.opacity < 0) {
        this.y = random(0, -100);
        this.length = 15;
        this.r = 0;
        this.opacity = 200;

      }
    }

  }
}

